# Change Log

## 3/8/2020
* (helloShader) Workspace changes are now tracked. User will be prompted with a save, discard, quit dialog when trying to close helloShader with unsaved changes. 
* (helloTexture) Texture format is now displayed as the formats for dxgi (d3d11, d3d12, opengl, and vulkan).
* (helloTexture) Added NaN detection.
* (helloTexture) Improved the speed of calculation texture histogram data.
* (helloGPU) The first mouse click on an unfocused window is now registered.
* (helloGPU) Fixed targa swizzling bug.
* (helloGPU) Complete overhaul of texture support. Support for more texture formats and faster texture loading.

## 10/1/2019
* (helloTexture) Fixed crash that occurs when opening an unsupported file type.
* (helloShader) Parameters can now be expanded and collapsed. Accompanied by expand/collapse all buttons.
* (helloShader) Added a clear search text button to the parameters search bar.
* (helloShader) New menu control to adjust window opacity.
* (helloShader) Menu items to show/hide all windows. Windows->Show All, Windows->Hide All.
* (helloShader) New option to hide overridden parameters.
* (helloShader) Matrix layout options for parameters moved to a new settings menu in the parameters window. The selected matrix layout option is now stored locally on the machine.
* (helloShader) Texture preview size ui setting is now stored on local machine.
* (helloGPU) Both helloShader and helloTexture will check to see if there is a newer version available. A menu item is also available to manually check for new releases.

## 09/13/2019
* (helloShader) Fixed bugs in the dialog to generate new shaders.
* (helloGPU) Added more clarity to hlsl error messages about mismatched input/output structs.

## 09/08/2019
* (helloShader) DirectX 11 shaders now contain debug information.
* (helloShader) New button to generate new shader files for a scene object.
* (helloShader) float3 and float4 parameters get a button to open a color picker.
* (helloShader) Visibility toggle added to each scene object in the scene object list.
* (helloShader) Added add/remove scene object buttons to the top of the scene objects list.
* (helloShader) Added a search field to the shader parameters window.
* (helloShader) Added an icon and tooltip indicating if an object shader parameter is being overidden by a scene shader parameter.
* (helloShader) The workspace extension .hsw is now obsolete. It has been replaced with graphics api specific extensions .hsx11 and .hsogl. Old projects will be automatically migrated.
* (helloShader) Fixed crash when creating a new workspace or opening a workspace and no workspace is currently loaded.
* (helloShader) Added a recents file list to main menu.
* (helloShader) New workspaces can now being created using any available graphics api. Application will automatically switch to the appropriate api.
* (helloShader) Fixed crash when switching graphics apis.
* (helloShader) Made changes to workspace file structure. Bumped to version 2.
* (helloGPU) Fixed crash in DirectX 11 when loading a png image that is RGB and has a color palette.
* (helloGPU) Fixed crash when loading 3d textures in DirectX 11.
* (helloGPU) Fixed loading png textures with gray or gray alpha formats in dx11.

## 08/22/2019
* (helloShader) Fixed bug that crashed helloShader when a texture had no file assigned to it.
* (helloShader) Fixed bug causing 'Generate Shader Templates' menu item to not work.
* (helloShader) Fixed bug causing menu bar to not appear after a project failed to load.
* (helloShader) Added instances parameter to scene object rendering.

## 08/17/2019
* (helloShader) New menu item 'Window->Restore Default Layout'. Will resize and resposition windows to the default layout. Adjusts for new window size.
* (helloShader) New ui window for camera properies. Camera properties are now saved in the workspace.
* (helloShader) Changed how scene object rotation works.
* (helloShader) Storing ui windows open/close state in the local machine config file.
* (helloShader) Texture ui window reflects the loading states of textures.
* (helloShader) Added a panel to see shader parameters for every object in the scene. This can be found in the parameters ui window under the 'Scene' tab.
* (helloShader) An error is now displayed when assigning a texture in the 'Textures' ui window that does not match the shader texture/sampler type.
* (helloShader) Fixed bug allowing incorrect texture types to be bound for a draw call.
* (helloShader) Shader texture/sampler type is now displayed for each texture in the texture ui window.
* (helloShader) Fixed bug causing gViewToWorld to be garbage values.
* (helloShader) Fixed bug causing hull and domain shaders to always be used after successfully assigning and compiling hull and domain shaders, regardless of the shader stages selected.
* (helloShader) Textures now load in the background. Still needs ui to show that a texture is being loaded.
* (helloShader) Meshes for scene objects updated with consistent conventions for binormals, tangents, and uvs.
* (helloShader) Fixed issue with shader entry point inputs that were longer than the default entry point.
* (helloShader) Scene objects now better indicate when they are loading and when they have errors
* (helloShader) Fixed bug when looking up shader constant historical values that have a different array size than the current shader constant.
* (helloGPU) Shader loading is now done completely on a background thread
* (helloGPU) Fixed bug that occasionally occurred when reloading shaders.
* (helloGPU) Fixed bug preventing file dialogs from opening when an invalid default path was specified.

## 04/24/2019
* (helloTexture) About dialog
* (helloShader) Controls dialog
* (helloShader) Fixed bug when saving shader or texture paths that were on different drives than the workspace.
* (helloShader) About dialog
* (helloShader) Shader parameters with a set min, max range have an improved input widget.
* (helloShader) Fixed available variables text to use float3x4 instead of float4x3.
* (helloShader) Fixed crash when trying to open the 'System->GPU Info' menu item.
* (helloShader) Fixed dynamic shader reloading in dx11.
* (helloShader) Fixed bug with file browser input display paths.
* (helloShader) Added basic shader stage input/output parameter verification to dx11 shader compilation.
* (helloGPU) Recreating shaders is now thread safe.
* (helloGPU) Fixed dx11 sampler states. They were not correctly storing their parameters.
* (helloGPU) Profile groups and gpu object debug names are now available in all builds.
* (helloGPU) Fixed uploading of float2x2, float2x3, float3x2, float3x3, float4x2, float4x3 matrices, as well as the double variants.

## 03/11/2019
* (helloShader) Fixed a bug when trying to find the next available scene object id when loading a workspace.
* (helloShader) Fixed input layout for the default shader
* (helloShader) Fixed issue with constant buffers not updating
* (helloShader) Improved iconography
* (helloShader) Added acknowledgements and credits to helloShader
* (helloGPU) Basic high dpi support.
* (helloGPU) Added license.

## 02/05/2019
* (helloShader) Generated shaders have more descriptive names
* (helloShader) Added button next to shader file input to open the file
* (helloShader) New projects will generate hello world shaders and assign them to the already created scene object
* (helloShader) Available global shader constants list has some description of what they are
* (helloShader) Orbiting camera orbits around the selected scene object
* (helloShader) New hotkey 'F' will focus on the selected scene object
* (helloShader) Creating a new workspace through the menu bar 'File'->'New Workspace' or from the keyboard shortcut will prompt with a save dialog
* (helloShader) Most recently opened workspace is remembered and will open when the helloShader
* (helloGPU) Application settings are saved to %USERPROFILE%/AppData/Local/helloGpu